package ru.yandex.qe.mail.meetings.services.abc;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import ru.yandex.qe.bus.MediaTypeConstants;
import ru.yandex.qe.mail.meetings.services.abc.dto.AbcCursorResponse;
import ru.yandex.qe.mail.meetings.services.abc.dto.AbcResponse;
import ru.yandex.qe.mail.meetings.services.abc.dto.AbcService;
import ru.yandex.qe.mail.meetings.services.abc.dto.ServiceMember;

@Path("api/v4")
@Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
public interface AbcApiV4 {
    @GET
    @Path("services/")
    AbcResponse<AbcService> services(
            @QueryParam("fields") String fields,
            @QueryParam("page_size")  int defaultLimit,
            @QueryParam("page")   int page
    );

    @GET
    @Path("services/members/")
    AbcCursorResponse<ServiceMember> members(
            @QueryParam("service") int service,
            @QueryParam("fields") String fields,
            @QueryParam("page_size")  int defaultLimit
    );
}
