package ru.yandex.qe.mail.meetings.services.abc.dto;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AbcCursorResponse<T> {
    @Nullable
    private final String next;
    private final List<T> results;

    @JsonCreator
    public AbcCursorResponse(@JsonProperty("next") String next, @JsonProperty("results") List<T> results) {
        this.next = next;
        this.results = results;
    }

    public String next() {
        return next;
    }

    public List<T> results() {
        return results;
    }
}
