package ru.yandex.qe.mail.meetings.services.abc.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AbcResponse<T> {
    private final int pages;
    private final List<T> results;

    @JsonCreator
    public AbcResponse(@JsonProperty("total_pages") int pages, @JsonProperty("results") List<T> results) {
        this.pages = pages;
        this.results = results;
    }

    public int pages() {
        return pages;
    }

    public List<T> results() {
        return results;
    }
}
