package ru.yandex.qe.mail.meetings.services.abc.dto;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class AbcService implements Comparable<AbcService> {
    public static final String ID = "id";
    public static final String SLUG = "slug";
    public static final String NAME = "name";

    private final Integer id;
    private final String slug;
    private final Map<String, String> name;

    @JsonCreator
    public AbcService(
            @JsonProperty(ID) Integer id,
            @JsonProperty(SLUG) String slug,
            @JsonProperty(NAME) Map<String, String>  name) {
        this.id = id;
        this.slug = slug;
        this.name = name;
    }

    public Integer id() {
        return id;
    }

    public String slug() {
        return slug;
    }

    public String name(String lang) {
        return name.get(lang);
    }

    public Map<String, String>  name() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AbcService that = (AbcService) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public int compareTo(AbcService abcService) {
        return id.compareTo(abcService.id);
    }
}
