package ru.yandex.qe.mail.meetings.services.blackbox.dto;

import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;

import ru.yandex.qe.mail.meetings.services.tvm.TvmDaemonClient;

/**
 * @author Sergey Galyamichev
 */
public abstract class BlackBoxRequest {
    private static final String YES = "yes";
    private static final String JSON = "json";

    private boolean userTicket;
    private String userip;
    private String method;
    private String format;
    private String serviceTicket;

    BlackBoxRequest(String method) {
        this.method = method;
        format = JSON;
        userTicket = true;
    }

    public String getMethod() {
        return method;
    }

    @QueryParam("method")
    public void setMethod(String method) {
        this.method = method;
    }

    public String getFormat() {
        return format;
    }

    @QueryParam("format")
    public void setFormat(String format) {
        this.format = format;
    }

    public String getUserTicket() {
        return userTicket ? YES : null;
    }

    @QueryParam("get_user_ticket")
    public void setUserTicket(boolean userTicket) {
        this.userTicket = userTicket;
    }

    public String getUserip() {
        return userip;
    }

    @QueryParam("userip")
    public void setUserip(String userip) {
        this.userip = userip;
    }

    public String getServiceTicket() {
        return serviceTicket;
    }

    @HeaderParam(TvmDaemonClient.SERVICE_TICKET_HEADER)
    public void setServiceTicket(String serviceTicket) {
        this.serviceTicket = serviceTicket;
    }
}
