package ru.yandex.qe.mail.meetings.services.blackbox.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Uid {
    private final String value;
    private final boolean lite;
    private final boolean hosted;
    private final String domid;
    private final String domain;
    private final String mx;

    public Uid(@JsonProperty("value") String value,
               @JsonProperty("lite") boolean lite,
               @JsonProperty("hosted") boolean hosted,
               @JsonProperty("domid") String domid,
               @JsonProperty("domain") String domain,
               @JsonProperty("mx") String mx) {
        this.value = value;
        this.lite = lite;
        this.hosted = hosted;
        this.domid = domid;
        this.domain = domain;
        this.mx = mx;
    }

    public String getValue() {
        return value;
    }

    public boolean isLite() {
        return lite;
    }

    public boolean isHosted() {
        return hosted;
    }

    public String getDomid() {
        return domid;
    }

    public String getDomain() {
        return domain;
    }

    public String getMx() {
        return mx;
    }
}
