package ru.yandex.qe.mail.meetings.services.calendar;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import ru.yandex.qe.mail.meetings.services.calendar.dto.EventInfoShort;
import ru.yandex.qe.mail.meetings.services.calendar.dto.ReplyData;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Response;
import ru.yandex.qe.mail.meetings.services.calendar.dto.WebEventCreateData;
import ru.yandex.qe.mail.meetings.services.calendar.dto.WebEventData;

/**
 * @author Sergey Galyamichev
 */
@Path("/")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON + "; " + MediaType.CHARSET_PARAMETER + "=" + "UTF-8")
public interface CalendarUpdate {

    @POST
    @Path("update-event")
    Response updateEvent(@QueryParam("id") int eventId,
                         @QueryParam("sequence") int sequence,
                         @QueryParam("instanceStartTs") String instanceStartTs,
                         @QueryParam("applyToFuture") Boolean applyToFuture,
                         @QueryParam("mailToAll") Boolean mailToAll,
                         @QueryParam("uid") String uid,
                         WebEventData event);

    @POST
    @Path("delete-event")
    Response deleteEvent(@QueryParam("id") int eventId,
                         @QueryParam("sequence") int sequence,
                         @QueryParam("instanceStartTs") String instanceStartTs,
                         @QueryParam("applyToFuture") Boolean applyToFuture,
                         @QueryParam("uid") String uid);

    @POST
    @Path("create-event")
    Response createEvent(WebEventCreateData event);

    @POST
    @Path("handle-reply")
    EventInfoShort handleReply(@QueryParam("uid") String uid,
                               ReplyData replyData);
}
