package ru.yandex.qe.mail.meetings.services.calendar;

import java.util.Date;
import java.util.List;

import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.RequestBody;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Event;
import ru.yandex.qe.mail.meetings.services.calendar.dto.EventSchedule;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Events;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Layer;
import ru.yandex.qe.mail.meetings.services.calendar.dto.MoveResult;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Offices;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Resources;
import ru.yandex.qe.mail.meetings.services.calendar.dto.User;
import ru.yandex.qe.mail.meetings.services.calendar.dto.suggest.SuggestBody;
import ru.yandex.qe.mail.meetings.services.calendar.dto.suggest.SuggestResponse;

/**
 * Calendar service methods interface
 *
 * @see <a href="https://wiki.yandex-team.ru/calendar/api/new-web">Calendar API</a>
 * for code details see <code>ru.yandex.calendar.frontend.webNew.actions.EventActions</code>
 *
 * @author Sergey Galiamichev
 */
@Path("/")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
@CacheConfig(cacheNames={"calendar-api-cache"})
public interface CalendarWeb {
    @GET
    @Path("get-resources-schedule")
    Offices getResourceSchedule(@QueryParam("office-id") int officeId,
                                @QueryParam("date") Date date);

    @GET
    @Path("get-resources-schedule")
    Offices getResourceSchedule(@QueryParam("office-id") List<Integer> officeId,
                                @QueryParam("from") Date from,
                                @QueryParam("to") Date to);

    @GET
    @Path("get-resources-schedule")
    Offices getResourceSchedule(@QueryParam("office-id") List<Integer> officeId,
                                @QueryParam("from") Date from,
                                @QueryParam("to") Date to,
                                @QueryParam("uid") String uid);

    @GET
    @Path("get-offices")
    Offices getOffices();

    @GET
    @Path("get-event")
    Event getEvent(@QueryParam("eventId") int eventId);

    @GET
    @Path("get-event")
    Event getEvent(@QueryParam("eventId") int eventId, @QueryParam("uid") String uid);

    @GET
    @Path("get-event")
    Event getEvent(@QueryParam("eventId") int eventId,
                   @QueryParam("instanceStartTs") String instanceStartTs,
                   @QueryParam("recurrenceAsOccurrence") Boolean recurrenceAsOccurrence);

    @GET
    @Path("get-event")
    JsonNode getEventJson(@QueryParam("eventId") int eventId);

    @GET
    @Path("get-user-or-resource-info")
    Resource.Info getResourceInfo(@QueryParam("email") String email);

    @GET
    @Path("get-user-or-resource-info")
    User getUser(@QueryParam("email") String email);

    @GET
    @Path("get-events-brief")
    Events getEventsBrief(@QueryParam("eventIds") String eventIds, @QueryParam("forResource") boolean forResource);

    @POST
    @Path("find-available-resources")
    Resources findAvailableResources(@QueryParam("uid") String uid,
                                     @QueryParam("office-id") Integer officeId,
                                     @QueryParam("filter") String filter,
                                     @QueryParam("tz") String tz,
                                     EventSchedule schedule);

    // todo merge into one???
    @GET
    @Path("get-events")
    Events getEvents(@QueryParam("uid") String uid,
                     @QueryParam("from") Date from,
                     @QueryParam("to") Date to);

    @GET
    @Path("get-events")
    Events getEvents(@QueryParam("uid") String uid,
                     @QueryParam("eventId") Integer eventId,
                     @QueryParam("from") String from,
                     @QueryParam("to") String to);

    @GET
    @Path("get-events")
    Events getEvents(@QueryParam("uid") String uid, @QueryParam("from") String from, @QueryParam("to") String to);

    @GET
    @Path("get-events")
    Events getEvents(@QueryParam("uid") String uid, @QueryParam("from") String from, @QueryParam("to") String to, @QueryParam("hideAbsences") boolean hideAbsences);

    @GET
    @Path("get-resource-description")
    Resource.Info getResourceDescription(@QueryParam("email") String email);

    @POST
    @Path("suggest-meeting-times")
    SuggestResponse suggestMeetingsTimes(@RequestBody SuggestBody body);

    @POST
    @Path("suggest-meeting-times")
    SuggestResponse suggestMeetingsTimes(@Nonnull @QueryParam("uid") String uid, @RequestBody SuggestBody body);

    @Cacheable
    @GET
    @Path("get-layer")
    Layer getLayer(@Nonnull @QueryParam("uid") String uid, @Nonnull @QueryParam("id") Long layerId);

    @POST
    @Path("move-resource")
    MoveResult moveResource(@QueryParam("sourceEventUid") String sourceUid,
                            @QueryParam("targetEventUid") String targetUid,
                            @QueryParam("sourceId") int sourceId,
                            @QueryParam("targetId") int targetId,
                            @QueryParam("resource") String resource,
                            @QueryParam("instanceStartTs") String instanceStartTs);
}
