package ru.yandex.qe.mail.meetings.services.calendar;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

/**
 * Provides date converter to process dates in required by calendar service format
 *
 * @author Sergey Galiamichev
 */
public class DateParameterConverterProvider implements ParamConverterProvider {
    private static final String FORMAT = "yyyy-MM-dd";
    public static final ParamConverter<Date> CONVERTER = new Converter();

    @Override
    public <T> ParamConverter<T> getConverter(Class<T> type, Type type1, Annotation[] antns) {
        return Date.class.equals(type) ? (ParamConverter<T>) CONVERTER : null;
    }

    private static class Converter implements ParamConverter<Date> {
        private static ThreadLocal<DateFormat> dateFormatHolder =
                ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT));

        @Override
        public Date fromString(String string) {
            try {
                return dateFormatHolder.get().parse(string);
            } catch (ParseException ex) {
                throw new WebApplicationException(ex);
            }
        }

        @Override
        public String toString(Date date) {
            return dateFormatHolder.get().format(date);
        }

    }
}
