package ru.yandex.qe.mail.meetings.services.calendar;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.UriBuilder;

import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

/**
 * The filter add specified uid to the calendar service request
 * @implNote Shall be eliminated/changed after TVM integration
 *
 * @author Sergey Galiamichev
 */
public class UidClientFilter implements ClientRequestFilter {
    private static final Set<String> IGNORE_PATH = Set.of();
    private String calendarUid;

    public UidClientFilter(String calendarUid) {
        this.calendarUid = calendarUid;
    }

    @Override
    public void filter(ClientRequestContext request) {
        // todo поддержать для post
        // todo alternatively support authorization and execute requests on behalf of logged in user
        String query = Optional.ofNullable(request.getUri().getQuery())
                .orElse("");
        boolean hasUidParam = URLEncodedUtils.parse(query, StandardCharsets.UTF_8).stream()
                .filter(p -> p.getValue() != null)
                .map(NameValuePair::getName)
                .anyMatch("uid"::equals);
        // на всякий случай лаем возможность исключить некоторые пути из фильтра
        if (!hasUidParam && !IGNORE_PATH.contains(request.getUri().getPath())) {
            request.setUri(UriBuilder.fromUri(request.getUri())
                    .queryParam("uid", calendarUid)
                    .build());
        }
    }
}
