package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Event extends EventDate implements EventJsonPatch, Intervalable {
    private EventType type;
    private String instanceStartTs;
    private String externalId;
    private String name;
    private String description;
    private boolean isAllDay;
    private int sequence;
    private EventUser organizer;
    private List<EventUser> attendees;
    private List<EventUser> optionalAttendees;
    private List<User> subscribers;
    private List<Resource.Info> resources;
    private String location;
    private String descriptionHtml;
    private String locationHtml;
    private boolean isRecurrence;
    private Repetition repetition;
    private EventActions actions;
    private boolean participantsCanInvite;
    private boolean participantsCanEdit;
    private boolean othersCanView;
    @JsonUnwrapped
    private WebEventUserData webEventUserData;
    private Decision decision;
    private Boolean isOnPrimaryLayer;
    private Boolean primaryLayerClosed;
    private boolean organizerLetToEditAnyMeeting;
    private boolean canAdminAllResources;
    private boolean repetitionNeedsConfirmation;
    private int totalAttendees;
    private int totalOptionalAttendees;

    @JsonCreator
    public Event(@JsonProperty("id") Integer eventId,
                 @JsonProperty("reservationId") Integer reservationId,
                 @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
                 @JsonProperty("startTs") Date start,
                 @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
                 @JsonProperty("endTs") Date end) {
        super(eventId, reservationId, start, end);
    }

    public EventType getType() {
        return type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public String getInstanceStartTs() {
        return instanceStartTs;
    }

    public void setInstanceStartTs(String instanceStartTs) {
        this.instanceStartTs = instanceStartTs;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean getIsAllDay() {
        return isAllDay;
    }

    public void setIsAllDay(boolean isAllDay) {
        this.isAllDay = isAllDay;
    }

    public int getSequence() {
        return sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @Nullable
    public EventUser getOrganizer() {
        return organizer;
    }

    public void setOrganizer(EventUser organizer) {
        this.organizer = organizer;
    }

    public List<EventUser> getAttendees() {
        return attendees;
    }

    public void setAttendees(List<EventUser> attendees) {
        this.attendees = attendees;
    }

    public List<EventUser> getOptionalAttendees() {
        return optionalAttendees;
    }

    public void setOptionalAttendees(List<EventUser> optionalAttendees) {
        this.optionalAttendees = optionalAttendees;
    }

    public List<User> getSubscribers() {
        return subscribers;
    }

    public void setSubscribers(List<User> subscribers) {
        this.subscribers = subscribers;
    }

    public List<Resource.Info> getResources() {
        return resources;
    }

    public void setResources(List<Resource.Info> resources) {
        this.resources = resources;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescriptionHtml() {
        return descriptionHtml;
    }

    public void setDescriptionHtml(String descriptionHtml) {
        this.descriptionHtml = descriptionHtml;
    }

    public String getLocationHtml() {
        return locationHtml;
    }

    public void setLocationHtml(String locationHtml) {
        this.locationHtml = locationHtml;
    }

    /**
     * Don't trust me! I'm occurrence
     *
     * @return true if event is exception for the underlying series
     */
    public boolean getIsRecurrence() {
        return isRecurrence;
    }

    public void setIsRecurrence(boolean isRecurrence) {
        this.isRecurrence = isRecurrence;
    }

    public WebEventUserData getWebEventUserData() {
        return webEventUserData;
    }

    public void setWebEventUserData(WebEventUserData webEventUserData) {
        this.webEventUserData = webEventUserData;
    }

    public Repetition getRepetition() {
        return repetition;
    }

    public void setRepetition(Repetition repetition) {
        this.repetition = repetition;
    }

    public EventActions getActions() {
        return actions;
    }

    public void setActions(EventActions actions) {
        this.actions = actions;
    }

    public boolean isParticipantsCanInvite() {
        return participantsCanInvite;
    }

    public void setParticipantsCanInvite(boolean participantsCanInvite) {
        this.participantsCanInvite = participantsCanInvite;
    }

    public boolean isParticipantsCanEdit() {
        return participantsCanEdit;
    }

    public void setParticipantsCanEdit(boolean participantsCanEdit) {
        this.participantsCanEdit = participantsCanEdit;
    }

    public boolean isOthersCanView() {
        return othersCanView;
    }

    public void setOthersCanView(boolean othersCanView) {
        this.othersCanView = othersCanView;
    }

    public Decision getDecision() {
        return decision;
    }

    public void setDecision(Decision decision) {
        this.decision = decision;
    }

    public Boolean getIsOnPrimaryLayer() {
        return isOnPrimaryLayer;
    }

    public void setIsOnPrimaryLayer(Boolean onPrimaryLayer) {
        isOnPrimaryLayer = onPrimaryLayer;
    }

    public Boolean getPrimaryLayerClosed() {
        return primaryLayerClosed;
    }

    public void setPrimaryLayerClosed(Boolean primaryLayerClosed) {
        this.primaryLayerClosed = primaryLayerClosed;
    }

    public boolean isOrganizerLetToEditAnyMeeting() {
        return organizerLetToEditAnyMeeting;
    }

    public void setOrganizerLetToEditAnyMeeting(boolean organizerLetToEditAnyMeeting) {
        this.organizerLetToEditAnyMeeting = organizerLetToEditAnyMeeting;
    }

    public boolean isCanAdminAllResources() {
        return canAdminAllResources;
    }

    public void setCanAdminAllResources(boolean canAdminAllResources) {
        this.canAdminAllResources = canAdminAllResources;
    }

    public boolean isRepetitionNeedsConfirmation() {
        return repetitionNeedsConfirmation;
    }

    public void setRepetitionNeedsConfirmation(boolean repetitionNeedsConfirmation) {
        this.repetitionNeedsConfirmation = repetitionNeedsConfirmation;
    }

    public int getTotalAttendees() {
        return totalAttendees;
    }

    public void setTotalAttendees(int totalAttendees) {
        this.totalAttendees = totalAttendees;
    }

    public int getTotalOptionalAttendees() {
        return totalOptionalAttendees;
    }

    public void setTotalOptionalAttendees(int totalOptionalAttendees) {
        this.totalOptionalAttendees = totalOptionalAttendees;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        Event event = (Event) o;
        return Objects.equals(instanceStartTs, event.instanceStartTs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), instanceStartTs);
    }
}
