package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EventDate implements Intervalable {
    private final Integer eventId; // null for reservation
    private final Integer reservationId; // null for events
    private final Date start;
    private final Date end;
    private String author;
    private User authorInfo;

    @JsonCreator
    public EventDate(@JsonProperty("eventId") Integer eventId,
                     @JsonProperty("reservationId") Integer reservationId,
                     @JsonProperty("start") Date start,
                     @JsonProperty("end") Date end) {
        this.eventId = eventId;
        this.reservationId = reservationId;
        this.start = start;
        this.end = end;
    }

    public Integer getEventId() {
        return eventId;
    }

    @JsonIgnore
    public boolean isEvent() {
        return eventId != null && reservationId == null;
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    public Date getStart() {
        return start;
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    public Date getEnd() {
        return end;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public User getAuthorInfo() {
        return authorInfo;
    }

    public void setAuthorInfo(User authorInfo) {
        this.authorInfo = authorInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EventDate eventDate = (EventDate) o;
        return Objects.equals(eventId, eventDate.eventId) &&
                Objects.equals(reservationId, eventDate.reservationId) &&
                Objects.equals(start, eventDate.start) &&
                Objects.equals(end, eventDate.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventId, reservationId, start, end);
    }

    @Override
    public String toString() {
        return "EventDate{" +
                "eventId=" + eventId +
                ", reservationId=" + reservationId +
                ", start=" + start +
                ", end=" + end +
                '}';
    }
}
