package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Sometimes it's so hard to call things by its name
 *
 * @author Sergey Galyamichev
 */
public interface EventJsonPatch {
    @JsonProperty("id")
    Integer getEventId();

    @JsonProperty("startTs")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    Date getStart();

    @JsonProperty("endTs")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    Date getEnd();
}
