package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EventSchedule {
    private final Date start;
    private final Date end;
    private final Repetition repetition;

    @JsonCreator
    public EventSchedule(@JsonProperty("start") Date start,
                         @JsonProperty("end") Date end,
                         @JsonProperty("repetition") Repetition repetition) {
        this.start = start;
        this.end = end;
        this.repetition = repetition;
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    public Date getStart() {
        return start;
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    public Date getEnd() {
        return end;
    }

    public Repetition getRepetition() {
        return repetition;
    }
}
