package ru.yandex.qe.mail.meetings.services.calendar.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EventUser extends User {

    private final Decision decision;

    @JsonCreator
    public EventUser(@JsonProperty("name") String name,
                     @JsonProperty("email") String email,
                     @JsonProperty("login") String login,
                     @JsonProperty("officeId") Integer officeId,
                     @JsonProperty("decision") Decision decision) {
        super(name, email, login, officeId);
        this.decision = decision;
    }

    public Decision getDecision() {
        return decision;
    }
}
