package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Office {
    private final int id;
    private final String name;
    private final String tzId;
    private final String tzOffset;
    private final String city;
    private final List<Resource> resources;

    public Office(@JsonProperty("id") int id,
                  @JsonProperty("name") String name,
                  @JsonProperty("tzId") String tzId,
                  @JsonProperty("tzOffset") String tzOffset,
                  @JsonProperty("cityName") String city,
                  @JsonProperty("resources") List<Resource> resources) {
        this.id = id;
        this.name = name;
        this.tzId = tzId;
        this.tzOffset = tzOffset;
        this.city = city;
        this.resources = resources;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getTzId() {
        return tzId;
    }

    public String getTzOffset() {
        return tzOffset;
    }

    public String getCity() {
        return city;
    }

    public List<Resource> getResources() {
        return resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Office office = (Office) o;
        return id == office.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "Office{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", city='" + city + '\'' +
                '}';
    }
}
