package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * @author Sergey Galyamichev
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Repetition {
    private Type type;
    private int each;
    private String weeklyDays;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT")
    private Date dueDate;
    private Boolean monthlyLastweek;

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getEach() {
        return each;
    }

    public void setEach(int each) {
        this.each = each;
    }

    public String getWeeklyDays() {
        return weeklyDays;
    }

    public void setWeeklyDays(String weeklyDays) {
        this.weeklyDays = weeklyDays;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Boolean getMonthlyLastweek() {
        return monthlyLastweek;
    }

    public void setMonthlyLastweek(Boolean monthlyLastweek) {
        this.monthlyLastweek = monthlyLastweek;
    }

    public enum Type {
        DAILY,
        WEEKLY,
        MONTHLY_NUMBER,
        MONTHLY_DAY_WEEKNO,
        YEARLY,
        NONE;

        @JsonValue
        public String toString() {
            return name().toLowerCase().replaceAll("_", "-");
        }
    }

    @Override
    public String toString() {
        return "Repetition{" +
                "type=" + type +
                ", each=" + each +
                ", weeklyDays='" + weeklyDays + '\'' +
                ", dueDate=" + dueDate +
                ", monthlyLastweek=" + monthlyLastweek +
                '}';
    }
}

