package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Resource {
    private final Info resourceInfo;
    private final List<Restrictions> restrictions;
    private final List<EventDate> events;

    public Resource(
            @JsonProperty("info") Info resourceInfo,
            @JsonProperty("restrictions") List<Restrictions> restrictions,
            @JsonProperty("events") List<EventDate> eventDates) {
        this.resourceInfo = resourceInfo;
        this.restrictions = restrictions != null ? restrictions : Collections.emptyList();
        this.events = eventDates;
    }

    public Info getResourceInfo() {
        return resourceInfo;
    }

    public List<EventDate> getEvents() {
        return events;
    }

    public List<Restrictions> getRestrictions() {
        return restrictions;
    }

    @JsonInclude
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Restrictions {
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT")
        private Date start;
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "GMT")
        private Date end;
        private String title;

        public Date getStart() {
            return start;
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public Date getEnd() {
            return end;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Info {
        private Integer id;
        private int officeId;
        private String name;
        private String alterName;
        private String email;
        private String phone;
        private String video;
        private String description;
        private int seats;
        private int capacity;
        private boolean voiceConferencing;
        private int projector;
        private int lcdPanel;
        private boolean markerBoard;
        private boolean desk;
        private boolean guestWifi;
        private Integer floor;
        private String mapUrl;
        private boolean active;
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT")
        private Date dueDate;
        private Integer availableRepetitions;

        @JsonProperty("resourceType")
        private Type resourceType;
        private Boolean hasPhone;
        private Boolean hasVideo;
        private String group;
        private Boolean canBook;
        private String protection;

        private Boolean repetitionUnacceptable;
        private Boolean canAdmin;
        private String cityName;
        private String officeName;
        private String groupName;
        private Integer tzOffset;
        private String type;

        public Integer getId() {
            return id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public int getOfficeId() {
            return officeId;
        }

        public void setOfficeId(int officeId) {
            this.officeId = officeId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlterName() {
            return alterName;
        }

        public String getEmail() {
            return email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPhone() {
            return phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getVideo() {
            return video;
        }

        public void setVideo(String video) {
            this.video = video;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getSeats() {
            return seats;
        }

        public void setSeats(int seats) {
            this.seats = seats;
        }

        public int getCapacity() {
            return capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public boolean isVoiceConferencing() {
            return voiceConferencing;
        }

        public void setVoiceConferencing(boolean voiceConferencing) {
            this.voiceConferencing = voiceConferencing;
        }

        public int getProjector() {
            return projector;
        }

        public void setProjector(int projector) {
            this.projector = projector;
        }

        public Date getDueDate() {
            return dueDate;
        }

        public void setDueDate(Date dueDate) {
            this.dueDate = dueDate;
        }

        public Integer getAvailableRepetitions() {
            return availableRepetitions;
        }

        public void setAvailableRepetitions(Integer availableRepetitions) {
            this.availableRepetitions = availableRepetitions;
        }

        public Boolean getHasPhone() {
            return hasPhone;
        }

        public Boolean getHasVideo() {
            return hasVideo;
        }

        public int getLcdPanel() {
            return lcdPanel;
        }

        public void setLcdPanel(int lcdPanel) {
            this.lcdPanel = lcdPanel;
        }

        public boolean isMarkerBoard() {
            return markerBoard;
        }

        public void setMarkerBoard(boolean markerBoard) {
            this.markerBoard = markerBoard;
        }

        public boolean isDesk() {
            return desk;
        }

        public void setDesk(boolean desk) {
            this.desk = desk;
        }

        public boolean isGuestWifi() {
            return guestWifi;
        }

        public void setGuestWifi(boolean guestWifi) {
            this.guestWifi = guestWifi;
        }

        public Integer getFloor() {
            return floor;
        }

        public void setFloor(Integer floor) {
            this.floor = floor;
        }

        public String getMapUrl() {
            return mapUrl;
        }

        public void setMapUrl(String mapUrl) {
            this.mapUrl = mapUrl;
        }

        public boolean isActive() {
            return active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Type getResourceType() {
            return resourceType;
        }

        public void setResourceType(Type resourceType) {
            this.resourceType = resourceType;
        }

        public Boolean isHasPhone() {
            return hasPhone;
        }

        public void setHasPhone(Boolean hasPhone) {
            this.hasPhone = hasPhone;
        }

        public Boolean isHasVideo() {
            return hasVideo;
        }

        public void setHasVideo(Boolean hasVideo) {
            this.hasVideo = hasVideo;
        }

        public String getGroup() {
            return group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Boolean getCanBook() {
            return canBook;
        }

        public void setCanBook(Boolean canBook) {
            this.canBook = canBook;
        }

        public String getProtection() {
            return protection;
        }

        public void setProtection(String protection) {
            this.protection = protection;
        }

        public Boolean getRepetitionUnacceptable() {
            return repetitionUnacceptable;
        }

        public void setRepetitionUnacceptable(Boolean repetitionUnacceptable) {
            this.repetitionUnacceptable = repetitionUnacceptable;
        }

        public Boolean getCanAdmin() {
            return canAdmin;
        }

        public void setCanAdmin(Boolean canAdmin) {
            this.canAdmin = canAdmin;
        }

        public String getCityName() {
            return cityName;
        }

        public void setCityName(String cityName) {
            this.cityName = cityName;
        }

        public String getOfficeName() {
            return officeName;
        }

        public void setOfficeName(String officeName) {
            this.officeName = officeName;
        }

        public String getGroupName() {
            return groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public Integer getTzOffset() {
            return tzOffset;
        }

        public void setTzOffset(Integer tzOffset) {
            this.tzOffset = tzOffset;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Info cloneRestrictions() {
            //todo vkokarev
            var copy =  new Info();
            copy.setOfficeId(officeId);
            copy.setCapacity(capacity);
            copy.setSeats(seats);

            copy.setVoiceConferencing(voiceConferencing);
            copy.setHasPhone(hasPhone);
            copy.setHasVideo(hasVideo);
            copy.setMarkerBoard(markerBoard);
            copy.setGuestWifi(guestWifi);
            copy.setDesk(desk);

            copy.setProjector(projector);
            copy.setLcdPanel(lcdPanel);

            return copy;
        }

        @Override
        public String toString() {
            return "{" + id + "|" + officeName + "|" + name + "}";
        }
    }

    public enum Type {
        ROOM,
        PARKING,
        APARTMENT,
        MASSAGE_ROOM,
        PROTECTED_ROOM,
        YAMONEY_ROOM,
        CAMPUS,
        PRIVATE_ROOM,
        HOTEL;

        public boolean isRoom() {
            return this == ROOM || this == PRIVATE_ROOM || this == PROTECTED_ROOM;
        }

        @Override
        @JsonValue
        public String toString() {
            return name().toLowerCase().replaceAll("_", "-");
        }
    }
}
