package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Resources {
    private final List<Resource.Info> resources;
    private final Integer foundTotal;

    @JsonCreator
    public Resources(@JsonProperty("resources") List<Resource.Info> resources,
                     @JsonProperty("foundTotal") Integer foundTotal) {
        this.resources = resources;
        this.foundTotal = foundTotal;
    }

    public List<Resource.Info> getResources() {
        return resources;
    }

    public Integer getFoundTotal() {
        return foundTotal;
    }
}
