package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Response {
    public static final String OK = "ok";

    private String status;
    private int sequence;
    private int showEventId;
    private Date showDate;
    private Date endTs;
    private String resourceName;
    private String resourceEmail;
    private String instanceStart;
    private String overlapStart;
    private List<String> externalIds;

    @JsonCreator
    public Response(@JsonProperty("status") String status,
                    @JsonProperty("sequence") int sequence,
                    @JsonProperty("showEventId") int showEventId,
                    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "Europe/Moscow")
                    @JsonProperty("showDate") Date showDate,
                    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
                    @JsonProperty("endTs") Date endTs,
                    @JsonProperty("resourceName") String resourceName,
                    @JsonProperty("resourceEmail") String resourceEmail,
                    @JsonProperty("instanceStart") String instanceStart,
                    @JsonProperty("overlapStart") String overlapStart,
                    @JsonProperty("externalIds") List<String> externalIds) {
        this.status = status;
        this.sequence = sequence;
        this.showEventId = showEventId;
        this.showDate = showDate;
        this.endTs = endTs;
        this.resourceName = resourceName;
        this.resourceEmail = resourceEmail;
        this.instanceStart = instanceStart;
        this.overlapStart = overlapStart;
        this.externalIds = externalIds;
    }

    public String getStatus() {
        return status;
    }

    public int getSequence() {
        return sequence;
    }

    public int getShowEventId() {
        return showEventId;
    }

    public Date getShowDate() {
        return showDate;
    }

    public Date getEndTs() {
        return endTs;
    }

    public List<String> getExternalIds() {
        return externalIds;
    }

    public String getResourceName() {
        return resourceName;
    }

    public String getResourceEmail() {
        return resourceEmail;
    }

    public String getInstanceStart() {
        return instanceStart;
    }

    public String getOverlapStart() {
        return overlapStart;
    }

    /**
     * Looks like it should be always true %)
     *
     * @return true
     */
    public boolean isOk() {
        return OK.equals(status);
    }

    @Override
    public String toString() {
        return "Response{" +
                "status='" + status + '\'' +
                ", sequence=" + sequence +
                ", showEventId=" + showEventId +
                ", showDate=" + showDate +
                ", endTs=" + endTs +
                ", resourceName='" + resourceName + '\'' +
                ", resourceEmail='" + resourceEmail + '\'' +
                ", instanceStart='" + instanceStart + '\'' +
                ", overlapStart='" + overlapStart + '\'' +
                ", externalIds=" + externalIds +
                '}';
    }
}
