package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class User {
    private final String name;
    private final String email;
    private final String login;
    private final Integer officeId;

    @JsonCreator
    public User(@JsonProperty("name") String name,
                @JsonProperty("email") String email,
                @JsonProperty("login") String login,
                @JsonProperty("officeId") Integer officeId) {
        this.name = name;
        this.email = email;
        this.login = login;
        this.officeId = officeId;
    }

    public String getName() {
        return name;
    }

    public String getEmail() {
        return email;
    }

    public String getLogin() {
        return login;
    }

    public Integer getOfficeId() {
        return officeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        User user = (User) o;
        return Objects.equals(officeId, user.officeId) &&
                Objects.equals(email, user.email) &&
                Objects.equals(login, user.login);
    }

    @Override
    public int hashCode() {
        return Objects.hash(email, login, officeId);
    }
}
