package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;


public final class WebEventCreateData {
    private EventType type;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    private Date startTs;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    private Date endTs;
    private String name;
    private String location;
    private String description;
    private String organizer;
    private List<String> attendees;
    private Repetition repetition;
    private boolean isAllDay = false;
    private boolean participantsCanInvite = true;
    private boolean participantsCanEdit = true;
    private boolean othersCanView = true;


    public WebEventCreateData(EventType type, Date startTs, Date endTs, String name, String description, String organizer, List<String> attendees, Repetition repetition) {
        this.type = type;
        this.startTs = startTs;
        this.endTs = endTs;
        this.name = name;
        this.description = description;
        this.organizer = organizer;
        this.attendees = attendees;
        this.repetition = repetition;
    }


    public EventType getType() {
        return type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public Date getStartTs() {
        return startTs;
    }

    public void setStartTs(Date startTs) {
        this.startTs = startTs;
    }

    public Date getEndTs() {
        return endTs;
    }

    public void setEndTs(Date endTs) {
        this.endTs = endTs;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrganizer() {
        return organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public List<String> getAttendees() {
        return attendees;
    }

    public void setAttendees(List<String> attendees) {
        this.attendees = attendees;
    }

    public Repetition getRepetition() {
        return repetition;
    }

    public void setRepetition(Repetition repetition) {
        this.repetition = repetition;
    }

    public boolean isAllDay() {
        return isAllDay;
    }

    public void setAllDay(boolean allDay) {
        isAllDay = allDay;
    }

    public boolean isParticipantsCanInvite() {
        return participantsCanInvite;
    }

    public void setParticipantsCanInvite(boolean participantsCanInvite) {
        this.participantsCanInvite = participantsCanInvite;
    }

    public boolean isParticipantsCanEdit() {
        return participantsCanEdit;
    }

    public void setParticipantsCanEdit(boolean participantsCanEdit) {
        this.participantsCanEdit = participantsCanEdit;
    }

    public boolean isOthersCanView() {
        return othersCanView;
    }

    public void setOthersCanView(boolean othersCanView) {
        this.othersCanView = othersCanView;
    }
}
