package ru.yandex.qe.mail.meetings.services.calendar.dto;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

/**
 * For never was a story of more woe
 *          than this of differs in and out objects...
 *
 * See <code>ru.yandex.calendar.frontend.webNew.dto.in.WebEventData</code> for details
 *
 * @author Sergey Galyamichev
 */
public class WebEventData {
    private EventType type;
    private Integer sid;
    private Boolean isAllDay;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    private Date startTs;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
    private Date endTs;
    private String name;
    private String location;
    private String description;
    private String mapUrl;
    private String url;
    private Boolean participantsCanInvite;
    private Boolean participantsCanEdit;
    private Boolean othersCanView;
    private String organizer;
    private List<String> attendees;
    private List<String> optionalAttendees;
    private Repetition repetition;
    @JsonUnwrapped
    private WebEventUserData userData;

    public EventType getType() {
        return type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public Integer getSid() {
        return sid;
    }

    public void setSid(Integer sid) {
        this.sid = sid;
    }

    public Boolean getAllDay() {
        return isAllDay;
    }

    public void setAllDay(Boolean allDay) {
        isAllDay = allDay;
    }

    public Date getStartTs() {
        return startTs;
    }

    public void setStartTs(Date startTs) {
        this.startTs = startTs;
    }

    public Date getEndTs() {
        return endTs;
    }

    public void setEndTs(Date endTs) {
        this.endTs = endTs;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMapUrl() {
        return mapUrl;
    }

    public void setMapUrl(String mapUrl) {
        this.mapUrl = mapUrl;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Boolean getParticipantsCanInvite() {
        return participantsCanInvite;
    }

    public void setParticipantsCanInvite(Boolean participantsCanInvite) {
        this.participantsCanInvite = participantsCanInvite;
    }

    public Boolean getParticipantsCanEdit() {
        return participantsCanEdit;
    }

    public void setParticipantsCanEdit(Boolean participantsCanEdit) {
        this.participantsCanEdit = participantsCanEdit;
    }

    public Boolean getOthersCanView() {
        return othersCanView;
    }

    public void setOthersCanView(Boolean othersCanView) {
        this.othersCanView = othersCanView;
    }

    public String getOrganizer() {
        return organizer;
    }

    public void setOrganizer(String organizer) {
        this.organizer = organizer;
    }

    public List<String> getAttendees() {
        return attendees;
    }

    public void setAttendees(List<String> attendees) {
        this.attendees = attendees;
    }

    public List<String> getOptionalAttendees() {
        return optionalAttendees;
    }

    public void setOptionalAttendees(List<String> optionalAttendees) {
        this.optionalAttendees = optionalAttendees;
    }

    public Repetition getRepetition() {
        return repetition;
    }

    public void setRepetition(Repetition repetition) {
        this.repetition = repetition;
    }

    public WebEventUserData getUserData() {
        return userData;
    }

    public void setUserData(WebEventUserData userData) {
        this.userData = userData;
    }

    public static WebEventData fromEvent(Event event) {
        WebEventData data = new WebEventData();
        data.type = event.getType();
        // data.sid ???
        data.isAllDay = event.getIsAllDay();
        data.startTs = event.getStart();
        data.endTs = event.getEnd();
        data.name = event.getName();
        data.location = event.getLocation();
        data.description = event.getDescription();
        data.mapUrl = event.getLocation();
        data.url = event.getLocation();
        data.participantsCanInvite = event.isParticipantsCanInvite();
        data.participantsCanEdit = event.isParticipantsCanEdit();
        data.othersCanView = event.isOthersCanView();
        data.organizer = event.getOrganizer() != null ? event.getOrganizer().getEmail() : null;
        List<String> attendees = event.getAttendees().stream()
                .map(User::getEmail)
                .collect(Collectors.toList());
        attendees.addAll(event.getResources().stream()
                .map(Resource.Info::getEmail)
                .collect(Collectors.toList()));
        List<String> optionalAttendees = event.getOptionalAttendees().stream()
                .map(User::getEmail)
                .collect(Collectors.toList());
        data.attendees = attendees;
        data.optionalAttendees = optionalAttendees;
        data.repetition = event.getRepetition();
        data.userData = event.getWebEventUserData();
        return data;
    }
}
