package ru.yandex.qe.mail.meetings.services.calendar.dto.faults;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class InvocationInfo {
    private final String reqId;
    private final String hostname;
    private final long execDurationMillis;
    private final String action;
    private final String hostId;
    private final String appName;
    private final String appVersion;

    public InvocationInfo(@JsonProperty("req-id") String reqId,
                          @JsonProperty("hostname") String hostname,
                          @JsonProperty("exec-duration-millis") long execDurationMillis,
                          @JsonProperty("action") String action,
                          @JsonProperty("host-id") String hostId,
                          @JsonProperty("app-name") String appName,
                          @JsonProperty("app-version") String appVersion) {
        this.reqId = reqId;
        this.hostname = hostname;
        this.execDurationMillis = execDurationMillis;
        this.action = action;
        this.hostId = hostId;
        this.appName = appName;
        this.appVersion = appVersion;
    }

    public String getReqId() {
        return reqId;
    }

    public String getHostname() {
        return hostname;
    }

    public long getExecDurationMillis() {
        return execDurationMillis;
    }

    public String getAction() {
        return action;
    }

    public String getHostId() {
        return hostId;
    }

    public String getAppName() {
        return appName;
    }

    public String getAppVersion() {
        return appVersion;
    }
}
