package ru.yandex.qe.mail.meetings.services.calendar.dto.suggest;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Repetition;

@JsonInclude(JsonInclude.Include.NON_NULL)
public final class SuggestBody {

    private static final ThreadLocal<SimpleDateFormat> SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"));
    private Mode mode = Mode.ANY_ROOM;

    private List<String> users = Collections.emptyList();

    private List<OfficeInfo> offices = Collections.emptyList();

//    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm", timezone = "MSK")
    private Date searchStart;

//    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm", timezone = "MSK")
    private Date eventStart;

//    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm", timezone = "MSK")
    private Date eventEnd;

    private int numberOfOptions = -1;

    private boolean ignoreUsersEvents = false;

    private Repetition repetition;

    public List<OfficeInfo> getOffices() {
        return offices;
    }

    public void setOffices(List<OfficeInfo> offices) {
        this.offices = offices;
    }

    public Mode getMode() {
        return mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public List<String> getUsers() {
        return users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public String getSearchStart() {
        return SDF.get().format(searchStart);
    }

    public void setSearchStart(Date searchStart) {
        this.searchStart = searchStart;
    }

    public String getEventStart() {
        return SDF.get().format(eventStart);
    }

    public void setEventStart(Date eventStart) {
        this.eventStart = eventStart;
    }

    public String getEventEnd() {
        return SDF.get().format(eventEnd);
    }

    public void setEventEnd(Date eventEnd) {
        this.eventEnd = eventEnd;
    }

    public int getNumberOfOptions() {
        return numberOfOptions;
    }

    public void setNumberOfOptions(int numberOfOptions) {
        this.numberOfOptions = numberOfOptions;
    }

    public Repetition getRepetition() {
        return repetition;
    }

    public void setRepetition(Repetition repetition) {
        this.repetition = repetition;
    }

    public boolean isIgnoreUsersEvents() {
        return ignoreUsersEvents;
    }

    public void setIgnoreUsersEvents(boolean ignoreUsersEvents) {
        this.ignoreUsersEvents = ignoreUsersEvents;
    }

    public static class OfficeInfo {
        private int id;
        private String filter = "";
        private List<String> selectedResourceEmails = Collections.emptyList();
        private int numberOfResources = 1;

        public OfficeInfo(int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getFilter() {
            return filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public List<String> getSelectedResourceEmails() {
            return selectedResourceEmails;
        }

        public void setSelectedResourceEmails(List<String> selectedResourceEmails) {
            this.selectedResourceEmails = selectedResourceEmails;
        }

        public int getNumberOfResources() {
            return numberOfResources;
        }

        public void setNumberOfResources(int numberOfResources) {
            this.numberOfResources = numberOfResources;
        }
    }

    public enum  Mode {
        ANY_ROOM,
        SOME_ROOM;

        @JsonValue
        public String toString() {
            return name().toLowerCase().replaceAll("_", "-");
        }
    }

}
