package ru.yandex.qe.mail.meetings.services.calendar.dto.suggest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class SuggestResponse {
    private List<Interval> intervals = new ArrayList<>();
    private String nextSearchStart;

    public List<Interval> getIntervals() {
        return intervals;
    }

    public void setIntervals(List<Interval> intervals) {
        this.intervals = intervals;
    }

    public String getNextSearchStart() {
        return nextSearchStart;
    }

    public void setNextSearchStart(String nextSearchStart) {
        this.nextSearchStart = nextSearchStart;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Interval {
        private static final ThreadLocal<SimpleDateFormat> _SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));

        private Date start;
        private Date end;

        private List<Place> places;


        public Date getEnd() {
            return end;
        }

        public void setEnd(String end) {
            try {
                this.end = _SDF.get().parse(end);
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public List<Place> getPlaces() {
            return places;
        }

        public void setPlaces(List<Place> places) {
            this.places = places;
        }

        public Date getStart() {
            return start;
        }

        public void setStart(String start) {
            try {
                this.start = _SDF.get().parse(start);
            } catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public org.joda.time.Interval interval() {
            return new org.joda.time.Interval(start.getTime(), end.getTime());
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Place {
        private int officeId;
        private List<Resource.Info> resources;

        public int getOfficeId() {
            return officeId;
        }

        public void setOfficeId(int officeId) {
            this.officeId = officeId;
        }

        public List<Resource.Info> getResources() {
            return resources;
        }

        public void setResources(List<Resource.Info> resources) {
            this.resources = resources;
        }
    }
}
