package ru.yandex.qe.mail.meetings.services.gaps.dto;

import java.util.Calendar;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.mail.meetings.utils.DateRange;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Gap {
    private int id;
    private String workflow;
    private Date dateFrom;
    private Date dateTo;
    private String comment;
    private boolean workInAbsence;
    private boolean fullDay;

    @JsonCreator
    public Gap(@JsonProperty("id") int id,
               @JsonProperty("workflow") String workflow,
               @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
               @JsonProperty("date_from") Date dateFrom,
               @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss", timezone = "Europe/Moscow")
               @JsonProperty("date_to") Date dateTo,
               @JsonProperty("comment") String comment,
               @JsonProperty("work_in_absence") boolean workInAbsence,
               @JsonProperty("full_day") boolean fullDay) {
        this.id = id;
        this.workflow = workflow;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.comment = comment;
        this.workInAbsence = workInAbsence;
        this.fullDay = fullDay;
    }

    public int getId() {
        return id;
    }

    public String getWorkflow() {
        return workflow;
    }

    public Date getDateFrom() {
        if (fullDay) {
            return dateFrom;
        }
        return DateRange.fromUTCtoMSK(dateFrom);
    }

    public Date getDateTo() {
        if (fullDay) {
            return dateTo;
        }
        return DateRange.fromUTCtoMSK(dateTo);
    }

    @JsonIgnore
    public Date getDateToRounded() {
        Calendar c = Calendar.getInstance();
        c.setTime(dateTo);
        DateRange.toStartOfADay(c);
        if (!dateTo.after(c.getTime())) {
            c.add(Calendar.DAY_OF_MONTH, -1);
        }
        return c.getTime();
    }

    public String getComment() {
        return comment;
    }

    public boolean isWorkInAbsence() {
        return workInAbsence;
    }

    public boolean isFullDay() {
        return fullDay;
    }
}
