package ru.yandex.qe.mail.meetings.services.staff;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import ru.yandex.qe.bus.MediaTypeConstants;
import ru.yandex.qe.mail.meetings.services.staff.dto.Person;
import ru.yandex.qe.mail.meetings.services.staff.dto.PersonContainer;
import ru.yandex.qe.mail.meetings.services.staff.dto.Response;
import ru.yandex.qe.mail.meetings.services.staff.dto.StaffGroup;

@Path("v3")
@Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
public interface StaffApiV3 {
    @GET
    @Path("persons")
    Response<Person> persons(@QueryParam("_fields") String fields,
                             @QueryParam("_limit") int limit,
                             @QueryParam("_page") int page);

    @GET
    @Path("persons")
    Response<Person> persons(@QueryParam("_fields") String fields,
                             @QueryParam("_limit") int limit,
                             @QueryParam("_page") int page,
                             @QueryParam("official.is_dismissed") boolean dismissed);

    @POST
    @Path("persons")
    Response<Person> persons(@QueryParam("_fields") String fields,
                             @QueryParam("_limit") int limit,
                             @QueryParam("_page") int page,
                             @QueryParam("official.is_dismissed") boolean dismissed,
                             @QueryParam("login") String logins);

    @GET
    @Path("persons")
    Response<Person> person(@QueryParam("_fields") String fields,
                            @QueryParam("uid") String uid,
                            @QueryParam("login") String login);

    @GET
    @Path("groups")
    Response<StaffGroup> groups(@QueryParam("_fields") String fields,
                                @QueryParam("_limit") int limit,
                                @QueryParam("_page") int page);

    @GET
    @Path("groupmembership")
    Response<PersonContainer> groupMembership(
            @QueryParam("_fields") String fields,
            @QueryParam("_limit") int limit,
            @QueryParam("_page") int page,
            @QueryParam("group.id") int groupId
    );
}
