package ru.yandex.qe.mail.meetings.services.staff.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class Account {
    public static final String ID = "id";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String PRIVATE = "private";
    public static final String VALUE_LOWER = "value_lower";

    private final Integer id;
    private final String value;
    private final String type;
    private final boolean isPrivate;
    private final String valueLower;

    public Account(@JsonProperty(ID) Integer id,
                   @JsonProperty(VALUE) String value,
                   @JsonProperty(TYPE) String type,
                   @JsonProperty(PRIVATE) boolean isPrivate,
                   @JsonProperty(VALUE_LOWER) String valueLower) {
        this.id = id;
        this.value = value;
        this.type = type;
        this.isPrivate = isPrivate;
        this.valueLower = valueLower;
    }

    public Integer getId() {
        return id;
    }

    public String getValue() {
        return value;
    }

    public String getType() {
        return type;
    }

    public boolean isPrivate() {
        return isPrivate;
    }

    public String getValueLower() {
        return valueLower;
    }
}
