package ru.yandex.qe.mail.meetings.services.staff.dto;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Email {
    public final static String ID = "id";
    public static final String SOURCE_TYPE = "source_type";
    public static final String ADDRESS = "address";
    private final int id;
    private final SourceType sourceType;
    private final String address;

    @JsonCreator
    public Email(@JsonProperty(ID) int id,
                 @JsonProperty(SOURCE_TYPE) SourceType sourceType,
                 @JsonProperty(ADDRESS) String address) {
        this.id = id;
        this.sourceType = sourceType;
        this.address = address;
    }

    public int getId() {
        return id;
    }

    public SourceType getSourceType() {
        return sourceType;
    }

    public String getAddress() {
        return address;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Email email = (Email) o;
        return id == email.id &&
                sourceType == email.sourceType &&
                Objects.equals(address, email.address);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, sourceType, address);
    }

    public enum SourceType {
        @JsonProperty("staff")
        STAFF,
        @JsonProperty("passport")
        PASSPORT,
        @JsonProperty("crm")
        CRM,
        @JsonProperty("work")
        WORK,
    }

}
