package ru.yandex.qe.mail.meetings.services.staff.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
public class Languages {
    public final static String CONTENT = "content";
    public final static String UI = "ui";
    public final static String AUTO_TRANSLATE = "auto_translate";
    public final static String NATIVE = "native";

    private final String content;
    private final Language ui;
    private final boolean autoTranslate;
    private final Language nativeLanguage;

    public Languages(@JsonProperty(CONTENT) String content,
                     @JsonProperty(UI) Language ui,
                     @JsonProperty(AUTO_TRANSLATE) boolean autoTranslate,
                     @JsonProperty(NATIVE) Language nativeLanguage) {
        this.content = content;
        this.ui = ui;
        this.autoTranslate = autoTranslate;
        this.nativeLanguage = nativeLanguage;
    }

    public String getContent() {
        return content;
    }

    public Language getUi() {
        return ui;
    }

    public boolean isAutoTranslate() {
        return autoTranslate;
    }

    public Language getNative() {
        return nativeLanguage;
    }
}
