package ru.yandex.qe.mail.meetings.services.staff.dto;

import java.util.Map;
import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public class LocalizedString {
    @Nonnull
    private final Map<Language, String> values;

    @JsonCreator
    public LocalizedString(@Nonnull Map<Language, String> values) {
        this.values = values;
    }

    @Nonnull
    @JsonValue
    public Map<Language, String> getValues() {
        return values;
    }

    @Nullable
    public String get(Language language) {
        return values.get(language);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LocalizedString that = (LocalizedString) o;
        return values.equals(that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(values);
    }
}
