package ru.yandex.qe.mail.meetings.services.staff.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.mail.meetings.utils.OfficeHelper;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class Office {
    private final String code;
    private final Integer id;

    public Office(
            @JsonProperty("id") Integer id,
            @JsonProperty("code") String code) {
        this.id = id;
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public Integer getId() {
        return id;
    }

    public Integer getIdAsCalendarOffice() {
        return OfficeHelper.calendarOfficeIdByStaffId(id).orElse(-1);
    }
}
