package ru.yandex.qe.mail.meetings.services.staff.dto;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * @author Sergey Galyamichev
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Official {
    public static final String AFFILIATION = "affiliation";
    public static final String CONTRACT_ENDED_AT = "contract_ended_at";
    public static final String EMPLOYMENT = "employment";
    public static final String HAS_BYOD_ACCESS = "has_byod_access";
    public static final String IS_DISMISSED = "is_dismissed";
    public static final String IS_HOMEWORKER = "is_homeworker";
    public static final String IS_ROBOT = "is_robot";
    public static final String IS_TRAINEE = "is_trainee";
    public static final String JOIN_AT = "join_at";
    public static final String NDA_ENDED_AT = "nda_ended_at";
    public static final String QUIT_AT = "quit_at";
    public static final String WIRETAP = "wiretap";

    private final String affiliation;
    private final String contractEndedAt;
    private final String employment;
    private final boolean hasByodAccess;
    private final boolean isDismissed;
    private final boolean isHomeworker;
    private final boolean isRobot;
    private final boolean isTrainee;
    private final String joinAt;
    @Nullable
    private final String ndaEndedAt;
    @Nullable
    private final String quitAt;
    private final boolean wiretap;

    @JsonCreator
    public Official(@JsonProperty(AFFILIATION) String affiliation,
                    @JsonProperty(CONTRACT_ENDED_AT) String contractEndedAt,
                    @JsonProperty(EMPLOYMENT) String employment,
                    @JsonProperty(HAS_BYOD_ACCESS) boolean hasByodAccess,
                    @JsonProperty(IS_DISMISSED) boolean isDismissed,
                    @JsonProperty(IS_HOMEWORKER) boolean isHomeworker,
                    @JsonProperty(IS_ROBOT) boolean isRobot,
                    @JsonProperty(IS_TRAINEE) boolean isTrainee,
                    @JsonProperty(JOIN_AT) String joinAt,
                    @Nullable @JsonProperty(NDA_ENDED_AT) String ndaEndedAt,
                    @Nullable @JsonProperty(QUIT_AT) String quitAt,
                    @JsonProperty(WIRETAP) boolean wiretap) {
        this.affiliation = affiliation;
        this.contractEndedAt = contractEndedAt;
        this.employment = employment;
        this.hasByodAccess = hasByodAccess;
        this.isDismissed = isDismissed;
        this.isHomeworker = isHomeworker;
        this.isRobot = isRobot;
        this.isTrainee = isTrainee;
        this.joinAt = joinAt;
        this.ndaEndedAt = ndaEndedAt;
        this.quitAt = quitAt;
        this.wiretap = wiretap;
    }

    public String getAffiliation() {
        return affiliation;
    }

    public String getContractEndedAt() {
        return contractEndedAt;
    }

    public String getEmployment() {
        return employment;
    }

    @JsonProperty(HAS_BYOD_ACCESS)
    public boolean isHasByodAccess() {
        return hasByodAccess;
    }

    @JsonProperty(IS_DISMISSED)
    public boolean isDismissed() {
        return isDismissed;
    }

    @JsonProperty(IS_HOMEWORKER)
    public boolean isHomeworker() {
        return isHomeworker;
    }

    @JsonProperty(IS_ROBOT)
    public boolean isRobot() {
        return isRobot;
    }

    @JsonProperty(IS_TRAINEE)
    public boolean isTrainee() {
        return isTrainee;
    }

    public String getJoinAt() {
        return joinAt;
    }

    @Nullable
    public String getNdaEndedAt() {
        return ndaEndedAt;
    }

    @Nullable
    public String getQuitAt() {
        return quitAt;
    }

    public boolean isWiretap() {
        return wiretap;
    }

    public enum Affiliation {
        @JsonProperty("yandex")
        YANDEX,
        @JsonProperty("yamoney")
        YAMONEY,
        @JsonProperty("external")
        EXTERNAL
    }

    public enum Employment {
        @JsonProperty("full")
        FULL,
        @JsonProperty("partial")
        PARTIAL,
        @JsonProperty("secondary")
        SECONDARY
    }
}
