package ru.yandex.qe.mail.meetings.services.staff.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Response<T> {
    private final int page;
    private final int limit;
    private final int total;
    private final int pages;
    private final List<T> result;

    @JsonCreator
    public Response(@JsonProperty("page") int page,
                    @JsonProperty("limit") int limit,
                    @JsonProperty("total") int total,
                    @JsonProperty("pages") int pages,
                    @JsonProperty("result") List<T> result
    ) {
        this.page = page;
        this.limit = limit;
        this.total = total;
        this.pages = pages;
        this.result = result;
    }

    public int getPage() {
        return page;
    }

    public int getLimit() {
        return limit;
    }

    public int getTotal() {
        return total;
    }

    public int getPages() {
        return pages;
    }

    public List<T> getResult() {
        return result;
    }
}
