package ru.yandex.qe.mail.meetings.services.staff.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;



@JsonIgnoreProperties(ignoreUnknown = true)
public class StaffGroup implements Comparable<StaffGroup> {
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String IS_DELETED = "is_deleted";
    public static final String NAME = "name";
    public static final String URL = "url";

    private final int id;
    private final String description;
    private final boolean isDeleted;
    private final String name;
    private final String url;


    @JsonCreator
    public StaffGroup(
            @JsonProperty(ID) int id,
            @JsonProperty(DESCRIPTION) String description,
            @JsonProperty(IS_DELETED) boolean isDeleted,
            @JsonProperty(NAME) String name,
            @JsonProperty(URL) String url) {
        this.id = id;
        this.description = description;
        this.isDeleted = isDeleted;
        this.name = name;
        this.url = url;
    }

    public int id() {
        return id;
    }

    public String description() {
        return description;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public String name() {
        return name;
    }

    public String url() {
        return url;
    }

    @Override
    public int compareTo(StaffGroup staffGroup) {
        return Integer.compare(id, staffGroup.id);
    }
}
