package ru.yandex.qe.mail.meetings.services.tvm;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import ru.yandex.qe.bus.MediaTypeConstants;
import ru.yandex.qe.mail.meetings.services.tvm.dto.ServiceTicket;
import ru.yandex.qe.mail.meetings.services.tvm.dto.TvmTicket;
import ru.yandex.qe.mail.meetings.services.tvm.dto.UserTicket;

/**
 * @author Sergey Galyamichev
 */
@Path("tvm")
@Produces(MediaTypeConstants.APPLICATION_JSON_WITH_UTF)
public interface TvmDaemonClient {
    String SERVICE_TICKET_HEADER = "X-Ya-Service-Ticket";
    String USER_TICKET_HEADER = "X-Ya-User-Ticket";

    @Path("tickets")
    @GET
    Map<String, TvmTicket> getTickets(@QueryParam("dsts") @Nonnull List<String> dst,
                                      @QueryParam("src") @Nullable String scr);

    @Path("checksrv")
    @GET
    ServiceTicket checkService(@HeaderParam(SERVICE_TICKET_HEADER) @Nonnull String ticket);

    @Path("checkusr")
    @GET
    UserTicket checkUser(@HeaderParam(USER_TICKET_HEADER) @Nonnull String ticket,
                         @QueryParam("override_env") @Nullable String env);
}
