package ru.yandex.qe.mail.meetings.storage;

import java.util.Comparator;
import java.util.List;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Repository;

import ru.yandex.qe.mail.meetings.analisys.InspectedItem;
import ru.yandex.qe.mail.meetings.blamer.DeclineEvent;
import ru.yandex.qe.mail.meetings.domain.EventExportObject;
import ru.yandex.qe.mail.meetings.domain.EventRecord;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;
import ru.yandex.qe.mail.meetings.storage.s3.YTStorage;
import ru.yandex.qe.yt.cypress.entities.YTTableEntities;
import ru.yandex.qe.yt.cypress.objects.tables.ColumnSchema;
import ru.yandex.qe.yt.cypress.objects.tables.ColumnType;
import ru.yandex.qe.yt.cypress.objects.tables.SortOrder;
import ru.yandex.qe.yt.cypress.objects.tables.TableSchema;

@Repository
public class CalendarStorage {
    @Inject
    private YTStorage ytStorage;

    public boolean storeEvents(String path, List<EventRecord> eventRecords) {
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder();
        tableSchemaBuilder
                .uniqueKeys(false)
                .strict(false)
                .addColumns(
                        ColumnSchema.builder()
                                .type(ColumnType.INT64)
                                .name("eventId")
                                .sortOrder(SortOrder.ASCENDING)
                                .build(),
                        ColumnSchema.builder()
                                .type(ColumnType.INT64)
                                .name("officeId")
                                .build(),
                        ColumnSchema.builder()
                                .type(ColumnType.INT64)
                                .name("resourceId")
                                .build(),
                        ColumnSchema.builder()
                                .type(ColumnType.INT64)
                                .name("attendees")
                                .build());
        return ytStorage.write(path, tableSchemaBuilder.build(), YTTableEntities.of(eventRecords)).getStatus() ==
                Response.Status.OK.getStatusCode();
    }

    public boolean storeResources(String path, List<Resource.Info> values) {
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder();
        tableSchemaBuilder
                .uniqueKeys(true)
                .strict(false)
                .addColumns(
                        ColumnSchema.builder()
                                .type(ColumnType.INT64)
                                .name("id")
                                .sortOrder(SortOrder.ASCENDING)
                                .build(),
                        ColumnSchema.builder()
                                .type(ColumnType.INT64)
                                .name("officeId")
                                .sortOrder(SortOrder.ASCENDING)
                                .build()
                );
        return ytStorage.write(path, tableSchemaBuilder.build(), YTTableEntities.of(values)).getStatus() ==
                Response.Status.OK.getStatusCode();
    }

    public boolean storeDeclines(String path, List<DeclineEvent> events) {
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder();
        tableSchemaBuilder
                .strict(false)
                .addInt64Column("eventId")
                .addStringColumn("resourceEmail")
                .addStringColumn("login")
                .addStringColumn("name")
                .addStringColumn("email");
        events.sort(Comparator.comparing(DeclineEvent::getEventId));
        return ytStorage.write(path, tableSchemaBuilder.build(), YTTableEntities.of(events)).getStatus() ==
                Response.Status.OK.getStatusCode();
    }

    public void storePublicEvents(@Nonnull String path, List<EventExportObject> events) {
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder()
                .lenient()
                .addInt64Column("officeId")
                .addInt64Column("resourceId")
                .addStringColumn("startTs")
                .addStringColumn("endTs")
                .addInt64Column("duration")
                .addInt64Column("attendees");
        ytStorage.write(path, tableSchemaBuilder.build(), YTTableEntities.of(events));
    }

    public void storeForecast(@Nonnull String path, List<InspectedItem> items) {
        TableSchema.Builder tableSchemaBuilder = TableSchema.builder()
                .lenient()
                .addStringColumn("threshold")
                .addInt64Column("baseEventId")
                .addInt64Column("eventId")
                .addInt64Column("resourceId")
                .addStringColumn("user")
                .addStringColumn("resourceEmail")
                .addStringColumn("message");
        ytStorage.write(path, tableSchemaBuilder.build(), YTTableEntities.of(items));
    }
}
