package ru.yandex.qe.mail.meetings.storage.s3;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.qe.telemetry.metrics.yasm.YasmMetricRegistry;
import ru.yandex.qe.yt.cypress.Cypress;
import ru.yandex.qe.yt.cypress.compression.CompressionCodec;
import ru.yandex.qe.yt.cypress.entities.YTTableEntity;
import ru.yandex.qe.yt.cypress.http.builders.HttpCypressBuilder;
import ru.yandex.qe.yt.cypress.http.builders.HttpCypressBuilderFactoryBean;
import ru.yandex.qe.yt.cypress.objects.CypressObjectType;
import ru.yandex.qe.yt.cypress.objects.tables.TableSchema;
import ru.yandex.qe.yt.cypress.objects.tables.TableWriter;
import ru.yandex.qe.yt.cypress.operations.JobIO;
import ru.yandex.qe.yt.cypress.operations.SortOperationSpec;
import ru.yandex.qe.yt.cypress.operations.SortPartitionOptions;
import ru.yandex.qe.yt.cypress.ypath.ObjectYPath;

import static java.util.Collections.singletonMap;

/**
 * @author selivanov 2019-06-20
 */
@Component
public class YTStorage {
    private static final Logger LOG = LoggerFactory.getLogger(YTStorage.class);

    private static final String EXPIRATION_TIME = "expiration_time";

    private static final long PARTITION_DATA_SIZE = 1024 * 1024 * 512L;
    private static final long ROW_MAX_WEIGHT = 1024 * 1024 * 120;
    private static final Map<String, Long> SORT_REPLICATION_FACTOR = singletonMap("intermediate_data_replication_factor", 2L);

    @Value("${plugin.yt.cypress.api.proxy.host}")
    String ytProxyHost;
    @Value("${calendar.yt.pool}")
    String ytPool;

    @Autowired
    HttpCypressBuilderFactoryBean dynamicCypress;

    @Inject
    public YTStorage(@Nonnull final HttpCypressBuilderFactoryBean dynamicCypress,
//                     @Value("${yt.input.bucket.name://home/qe/scraper/dev/input-tables}") @Nonnull final String,
                     @Nonnull final YasmMetricRegistry metricRegistry) {

        this.dynamicCypress = dynamicCypress;
    }

    public Response read(String host, String path) {
        getCypress(host);

//        OperationYPath serpPath = OperationYPath.parseObject(path).columns(SOY_CONTENT_COLUMN)
//                .ranges(ReadRange.exact(ReadLimit.key(id)));

//        String content = cypress.readTable(Optional.empty(), false, serpPath, entity -> {
//            Map<String, String> result = JsonUtils.read(entity.getInputSteam(), SOY_RESULT_TYPE);
//            return result.get(SOY_CONTENT_COLUMN);
//        });
//        if (content == null) {
//            throw new NotFoundException(
//                    String.format("Serp with request id '%s' has empty %s. Yt path: '%s'", id, SOY_CONTENT_COLUMN, path));
//        }
//        return Response.ok(content).build();
        return Response.ok("").build();
    }

    private Cypress getCypress(String host) {
        HttpCypressBuilder builder = dynamicCypress.getObject();
        builder.setTelemetryEnabled(false);
        builder.setYtProxyHost(host);
        return builder.build();
    }

    public boolean exists(String path) {
        Cypress cypress = getCypress(ytProxyHost);
        ObjectYPath tableYPath = ObjectYPath.parseObject(path);
        return cypress.exists(Optional.empty(), false, tableYPath);
    }

    public <T> Response write(String path, TableSchema tableSchema, YTTableEntity<T> entities) {
        Cypress cypress = getCypress(ytProxyHost);
        ObjectYPath tableYPath = ObjectYPath.parseObject(path);
        System.out.println("path = [" + path + "], tableSchema = [" + tableSchema + "], entries = [" + entities + "]");
        LOG.info("export to " + path);
        if (!cypress.exists(Optional.empty(), false, tableYPath)) {
            final Map<String, Object> attributesMap = new HashMap<>();
            attributesMap.put(CompressionCodec.YT_ATTRIBUTE_NAME, CompressionCodec.NONE.getYTName());
            attributesMap.put("schema", tableSchema);
            cypress.create(Optional.empty(), false, tableYPath, CypressObjectType.TABLE, attributesMap, true, true);
        }

//        cluster.write(
//                tablePath,
//                Optional.of(RawYtSchema.forObjectType(objectType)),
//                YtJsonEntities.nonRepeatable(
//                        Seq.seq(toSave).peek(__ -> cntr.incrementAndGet()).map(extractor()).iterator()
//                ),
//                createOrAppend
//        );
//        Optional.of(RawYtSchema.forObjectType(objectType)),
        cypress.writeTable(Optional.empty(), false, tableYPath.append(true), new TableWriter(ROW_MAX_WEIGHT), entities);
//        cypress.sort(Optional.empty(), false, getSortOperationSpec(tableYPath, t));
        return Response.ok("").build();
    }

    private SortOperationSpec getSortOperationSpec(ObjectYPath outputPath, String idColumn) {
        List<ObjectYPath> inputTables = Collections.singletonList(outputPath);
        return new SortOperationSpec(
                inputTables,
                outputPath,
                Collections.singletonList(idColumn),
                ytPool,
                new SortPartitionOptions(
                        null,
                        PARTITION_DATA_SIZE, // to minimize chunks usages
                        null,
                        null,
                        SORT_REPLICATION_FACTOR),
                new JobIO(new TableWriter(ROW_MAX_WEIGHT)),
                new JobIO(new TableWriter(ROW_MAX_WEIGHT)),
                new JobIO(new TableWriter(ROW_MAX_WEIGHT))
        );
    }
}
