package ru.yandex.qe.mail.meetings.synchronizer.dto;

import java.util.Objects;

public class IdWithType {
    public static final IdWithType NONE = new IdWithType(null, null);

    public final String id;
    public final SourceType type;

    public IdWithType(String id, SourceType type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IdWithType that = (IdWithType) o;
        return Objects.equals(id, that.id) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type);
    }

    @Override
    public String toString() {
        return id + "-" + type;
    }
}
