package ru.yandex.qe.mail.meetings.synchronizer.dto;

import java.util.Objects;

public class SyncEvent {
    private final String owner;
    private final int id;

    public SyncEvent(String owner, int id) {
        this.owner = owner;
        this.id = id;
    }

    public String owner() {
        return owner;
    }

    public int id() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SyncEvent syncEvent = (SyncEvent) o;
        return id == syncEvent.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
