package ru.yandex.qe.mail.meetings.synchronizer.impl;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import ru.yandex.qe.mail.meetings.services.abc.AbcClient;
import ru.yandex.qe.mail.meetings.services.abc.dto.AbcService;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.services.staff.dto.Person;


@Service("abcServicesImpl")
public class AbcServices extends UpdatableCache<AbcService> {
    private static final Logger LOG = LoggerFactory.getLogger(AbcServices.class);

    @Nonnull
    private final AbcClient abcClient;

    @Nonnull
    private final StaffClient staffClient;

    @Inject
    public AbcServices(@Nonnull AbcClient abcClient, @Nonnull StaffClient staffClient) {
        this.abcClient = abcClient;
        this.staffClient = staffClient;
    }

    @Override
    public List<Person> membersById(int serviceId) {
        return abcClient.members(serviceId)
                .parallelStream()
                .map(staffClient::getByLogin)
                .filter(p -> !p.getOfficial().isRobot())
                .filter(p -> !p.getOfficial().isDismissed())
                .collect(Collectors.toList());
    }


    @Override
    @Scheduled(fixedDelayString = "${abc.services.cron.update.delay}", initialDelayString = "${abc.services.cron.initial.delay:0}")
    protected synchronized void update() {
        super.update();
    }

    @Override
    protected String name(AbcService abcService, String lang) {
        return abcService.name(lang);
    }

    @Override
    protected Integer id(AbcService abcService) {
        return abcService.id();
    }

    @Override
    protected List<AbcService> load() {
        return abcClient.allServices();
    }
}
