package ru.yandex.qe.mail.meetings.synchronizer.impl;

import java.util.List;

import javax.annotation.Nonnull;
import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.services.staff.dto.Person;
import ru.yandex.qe.mail.meetings.services.staff.dto.StaffGroup;

@Service("staffGroups")
public class StaffGroups extends UpdatableCache<StaffGroup> {
    private static final Logger LOG = LoggerFactory.getLogger(StaffGroups.class);

    @Nonnull
    private final StaffClient staffClient;

    @Inject
    public StaffGroups(@Nonnull StaffClient staffClient) {
        this.staffClient = staffClient;
    }

    @Override
    public List<Person> membersById(int groupId) {
        return staffClient.groupMembers(groupId, false, false);
    }

    @Override
    @Scheduled(fixedDelayString = "${staff.groups.cron.update.delay}", initialDelayString = "${staff.services.cron.initial.delay:0}")
    protected synchronized void update() {
        super.update();
    }

    @Override
    protected List<StaffGroup> load() {
        return staffClient.getAllGroups();
    }

    @Override
    protected String name(StaffGroup staffGroup, String lang) {
        return staffGroup.name();
    }

    @Override
    protected Integer id(StaffGroup staffGroup) {
        return staffGroup.id();
    }
}
