package ru.yandex.qe.mail.meetings.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;

import ru.yandex.qe.mail.meetings.api.resource.dto.AddResourceRequest;
import ru.yandex.qe.mail.meetings.cron.actions.Contexts;

/**
 * @author Sergey Galyamichev
 */
public class FormConverters {
    public static final String BOOK_LABEL = "Создать встречу";
    public static final String SEARCH_LABEL = "Найти переговорку";
    public static final String SEARCH_CHANGE_LABEL = "Найти/заменить переговорку";
    public static final String MERGE_LABEL = "Объединить события";
    public static final String SWAP_LABEL = "Обмен переговорками";
    public static final String SWAP_OR_MOVE_LABEL = "Обмен/запрос переговорки";
    public static final String GROUP_ASSIGN_LABEL = "Добавить группу участников";

    public static final Map<String, Boolean> YES_NO = Map.of(
            "Да", Boolean.TRUE,
            "да", Boolean.TRUE,
            "True", Boolean.TRUE,
            "Нет", Boolean.FALSE,
            "нет", Boolean.FALSE,
            "False", Boolean.FALSE);

    public static final Map<String, String> FILTERS = Map.of(
            "Конференц-связь", "voice_conferencing",
            "Видеосвязь", "video",
            "ЖК-панель", "lcd_panel",
            "видео", "video",
            "необходимо видео", "video");

    public static final Map<String, Integer> OFFICES = Map.ofEntries(
            Map.entry("Алматы, БЦ Достык", 747),
            Map.entry("Алматы, БЦ «Достык»", 747),
            Map.entry("Алматы, БЦ Кок-Тобе", 821),
            Map.entry("Алматы, БЦ «Кок-Тобе»", 821),
            Map.entry("Астана, БЦ «Эмират»", 1120),
            Map.entry("Владивосток, БЦ Fresh Plaza", 785),
            Map.entry("Владивосток, БЦ \"Fresh Plaza\"", 785),
            Map.entry("Воронеж, БЦ Галеон", 818),
            Map.entry("Воронеж, БЦ «Галеон»", 818),
            Map.entry("Воронеж, БЦ Московский", 896),
            Map.entry("Екатеринбург, БЦ Палладиум", 3),
            Map.entry("Екатеринбург, БЦ «Палладиум»", 3),
            Map.entry("Казань, БЦ Сувар-Плаза", 143),
            Map.entry("Казань, БЦ «Сувар-Плаза»", 143),
            Map.entry("Казань, Иннополис", 711),
            Map.entry("Краснодар, БЦ Адмирал", 819),
            Map.entry("Краснодар, БЦ «Адмирал»", 819),
            Map.entry("Красноярск, БЦ Баланс", 898),
            Map.entry("Красноярск, БЦ «Баланс»", 898),
            Map.entry("Люцерн", 676),
            Map.entry("Швейцария, Люцерн", 676),
            Map.entry("Минск, БЦ RubinPlaza", 151),
            Map.entry("Минск, БЦ \"RubinPlaza\"", 151),
            Map.entry("Минск, БЦ \"RiveraPlaza\"", 1121),
            Map.entry("Москва, SDC.Роверы", 748),
            Map.entry("Москва, БЦ Аврора", 746),
            Map.entry("Москва, БЦ «Аврора»", 746),
            Map.entry("Москва, БЦ Зубовский", 899),
            Map.entry("Москва, БЦ «Зубовский»", 899),
            Map.entry("Москва, БЦ Мамонтов", 147),
            Map.entry("Москва, БЦ «Мамонтов»", 147),
            Map.entry("Москва, БЦ Морозов", 1),
            Map.entry("Москва, БЦ «Морозов»", 1),
            Map.entry("Moscow, BC Morozov", 1),
            Map.entry("Москва, БЦ Строганов", 148),
            Map.entry("Москва, БЦ «Строганов»", 148),
            Map.entry("Moscow, BC Stroganov", 148),
            Map.entry("Москва, БЦ «Шереметьевский»", 1122),
            Map.entry("Москва, Гараж беспилотников", 968),
            Map.entry("Москва, ТЦ Зелёный", 897),
            Map.entry("Москва, ТЦ «Зелёный»", 897),
            Map.entry("Москва, Техцентр Яндекс.Авто", 1041),
            Map.entry("Москва, Яндекс.Авто", 967),
            Map.entry("Москва, Яндекс.Образование", 784),
            Map.entry("Москва, БЦ «Око»", 1051),
            Map.entry("Набережные Челны, БЦ Технопарк", 1037),
            Map.entry("Нидерланды, Амстердам", 1040),
            Map.entry("Нижний Новгород, БЦ Coolibin", 934),
            Map.entry("Нижний Новгород, БЦ Лобачевский Plaza", 667),
            Map.entry("Нижний Новгород, БЦ «Лобачевский Plaza»", 667),
            Map.entry("Nizhny Novgorod, Lobachevsky Plaza", 667),
            Map.entry("Нижний Новгород, БЦ Орбита", 1039),
            Map.entry("Нижний Новгород, БЦ Ульянова 13", 895),
            Map.entry("Новосибирск, Академпарк", 712),
            Map.entry("Новосибирск, БЦ Гринвич", 4),
            Map.entry("Новосибирск, БЦ «Гринвич»", 4),
            Map.entry("Ньюберипорт", 8),
            Map.entry("Пермь, БЦ Гранд", 855),
            Map.entry("Пермь, БЦ «Гранд»", 855),
            Map.entry("Ростов-на-Дону, БЦ Пять Морей", 149),
            Map.entry("Ростов-на-Дону, БЦ «Пять Морей»", 149),
            Map.entry("Самара, БЦ Миллениум", 890),
            Map.entry("Самара, БЦ «Миллениум»", 890),
            Map.entry("Санкт-Петербург, БЦ Бенуа", 2),
            Map.entry("Санкт-Петербург, БЦ «Бенуа»", 2),
            Map.entry("St.Petersburg, Benua", 2),
            Map.entry("Санкт-Петербург, Партия Еды", 1003),
            Map.entry("Саратов, БЦ Ковчег", 1043),
            Map.entry("Саратов, БЦ Столыпин", 893),
            Map.entry("Саратов, БЦ «Столыпин»", 893),
            Map.entry("Симферополь", 7),
            Map.entry("Софьино, Фулфилмент центр", 1036),
            Map.entry("Сочи, Адлер", 820),
            Map.entry("Сочи, Кампус", 1038),
            Map.entry("Стамбул", 670),
            Map.entry("Турция, Стамбул", 670),
            Map.entry("Тель-Авив, Hab Yango", 969),
            Map.entry("Тель-Авив, Менахем Бегин офис", 1002),
            Map.entry("Тула, БЦ Троицкий", 894),
            Map.entry("Тула, БЦ «Троицкий»", 894),
            Map.entry("Тюмень, БЦ Альянс", 891),
            Map.entry("Тюмень, БЦ «Альянс»", 891),
            Map.entry("Уфа, БЦ Александровский пассаж", 889),
            Map.entry("Уфа, БЦ «Александровский пассаж»", 889),
            Map.entry("Цюрих", 157),
            Map.entry("Челябинск, БЦ Бовид", 892),
            Map.entry("Челябинск, БЦ «Бовид»", 892));

    public final static Map<Integer, String> OFFICES_IDS = OFFICES.entrySet().stream()
            .collect(Collectors.toMap(Map.Entry::getValue, Map.Entry:: getKey, (a, b) -> a));

    public static Boolean convertYesNo(String param) {
        return convertOne(param, FormConverters.YES_NO) == Boolean.TRUE;
    }

    public static <T> T convertOne(String parameter, Map<String, T> mapping) {
        return parameter == null ? null : mapping.get(parameter);
    }

    public static <T> List<T> convert(String parameter, Map<String, T> mapping) {
        if (parameter == null) {
            return Collections.emptyList();
        }
        List<T> result = new ArrayList<>();
        for (Map.Entry<String, T> pair : mapping.entrySet()) {
            if (parameter.contains(pair.getKey())) {
                result.add(pair.getValue());
            }
        }
        return result;
    }

    public static Contexts.Scan toScan(@Nonnull AddResourceRequest request) {
        Boolean isManual = convertYesNo(request.getManualOffice());
        String filter;
        if (request.getFilter() != null) {
            List<String> filters = convert(request.getFilter(), FormConverters.FILTERS);
            filter = String.join(",", filters);
        } else {
            filter = null;
        }
        Boolean isChange = convertYesNo(request.getChange());
        return Contexts.scan(!isManual, isChange, new HashSet<>(convert(request.getOffice(), FormConverters.OFFICES)), filter);
    }
}
