package ru.yandex.qe.mail.meetings.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OfficeHelper {
    private static final Map<String, CalendarStaffIdPair> MAPPING = Collections.unmodifiableMap(new TreeMap<>(){{
        put("БЦ Морозов", CalendarStaffIdPair.of(1, 1));
        put("БЦ Бенуа", CalendarStaffIdPair.of(2, 2));
        put("БЦ Достык", CalendarStaffIdPair.of(747, 180));
        put("БЦ Fresh Plaza", CalendarStaffIdPair.of(785, 184));
        put("БЦ Галеон", CalendarStaffIdPair.of(818, 191));
        put("БЦ Палладиум", CalendarStaffIdPair.of(3, 3));
        put("БЦ Сувар-Плаза", CalendarStaffIdPair.of(143, 143));
        put("БЦ Адмирал", CalendarStaffIdPair.of(819, 188));
        put("БЦ Баланс", CalendarStaffIdPair.of(898, 199));
        put("Люцерн", CalendarStaffIdPair.of(676, 158));
        put("БЦ RubinPlaza", CalendarStaffIdPair.of(151, 151));
        put("БЦ Технопарк", CalendarStaffIdPair.of(1037, 222));
        put("Амстердам", CalendarStaffIdPair.of(1040, 160));
        put("БЦ Coolibin", CalendarStaffIdPair.of(934, 212));
        put("Академпарк", CalendarStaffIdPair.of(712, 179));
        put("Ньюберипорт", CalendarStaffIdPair.of(8, 8));
        put("БЦ Гранд", CalendarStaffIdPair.of(855, 196));
        put("БЦ Пять Морей", CalendarStaffIdPair.of(149, 149));
        put("БЦ Миллениум", CalendarStaffIdPair.of(890, 190));
        put("БЦ Ковчег", CalendarStaffIdPair.of(1043, 254));
        put("Симферополь", CalendarStaffIdPair.of(7, 7));
        put("Фулфилмент центр", CalendarStaffIdPair.of(1036, 220));
        put("Адлер", CalendarStaffIdPair.of(820, 193));
        put("Стамбул", CalendarStaffIdPair.of(670, 166));
        put("Hab Yango", CalendarStaffIdPair.of(969, 219));
        put("БЦ Троицкий", CalendarStaffIdPair.of(894, 200));
        put("БЦ Альянс", CalendarStaffIdPair.of(891, 198));
        put("БЦ Александровский пассаж", CalendarStaffIdPair.of(889, 195));
        put("БЦ Бовид", CalendarStaffIdPair.of(892, 192));
        put("Датацентр «Владимир»", CalendarStaffIdPair.of(713, 175));
        put("БЦ Мамонтов", CalendarStaffIdPair.of(147, 147));
        put("БЦ Строганов", CalendarStaffIdPair.of(148, 148));
        put("БЦ Аврора", CalendarStaffIdPair.of(746, 181));
        put("Яндекс.Образование", CalendarStaffIdPair.of(784, 183));
        put("ТЦ Зелёный", CalendarStaffIdPair.of(897, 207));
        put("БЦ Зубовский", CalendarStaffIdPair.of(899, 206));
        put("Гараж беспилотников", CalendarStaffIdPair.of(968, 211));
//        put("БК Сити", CalendarStaffIdPair.of(1044, 1));
        put("БЦ Кок-Тобе", CalendarStaffIdPair.of(821, 194));
        put("БЦ Московский", CalendarStaffIdPair.of(896, 203));
        put("Иннополис", CalendarStaffIdPair.of(711, 178));
        put("БЦ Лобачевский Plaza", CalendarStaffIdPair.of(667, 161));
        put("БЦ Орбита", CalendarStaffIdPair.of(1039, 257));
        put("БЦ Ульянова 13", CalendarStaffIdPair.of(895, 205));
        put("БЦ Гринвич", CalendarStaffIdPair.of(4, 4));
        put("БЦ Столыпин", CalendarStaffIdPair.of(893, 186));
        put("Менахем Бегин офис", CalendarStaffIdPair.of(1002, 253));
        put("Датацентр «Ивантеевка»", CalendarStaffIdPair.of(751, 12));
        put("Датацентр «Мытищи»", CalendarStaffIdPair.of(750, 13));
        put("Датацентр «Сасово»", CalendarStaffIdPair.of(678, 155));
        put("Датацентр Мянтсяля", CalendarStaffIdPair.of(674, 163));
        put("БЦ Эмират", CalendarStaffIdPair.of(1120, 197));
        put("БЦ RiveraPlaza", CalendarStaffIdPair.of(1121, 202));
        put("БЦ Шереметьевский", CalendarStaffIdPair.of(1122, 204));
        put("БЦ «Око»", CalendarStaffIdPair.of(1051, 306));
//        put("Цюрих", CalendarStaffIdPair.of(157, ));
//        put("Кампус", CalendarStaffIdPair.of(1038, ));
//        put("БЦ Арсенал", CalendarStaffIdPair.of(, 163));
//        put("Партия Еды", CalendarStaffIdPair.of(1003, ));
//        put("Техцентр Яндекс.Авто", CalendarStaffIdPair.of(1041, ));
//        put("Яндекс.Авто", CalendarStaffIdPair.of(967, ));
//        put("SDC.Роверы", CalendarStaffIdPair.of(748, ));
    }});

    private static final Map<Integer, Integer> STAFF_TO_CALENDAR_MAPPING;
    private static final Map<Integer, Integer> CALENDAR_TO_STAFF_MAPPING;

    static {
        STAFF_TO_CALENDAR_MAPPING = MAPPING.values()
                .stream()
                .collect(Collectors.toUnmodifiableMap(p -> p.staffId, p -> p.calendarId));

        CALENDAR_TO_STAFF_MAPPING = MAPPING.values()
                .stream()
                .collect(Collectors.toUnmodifiableMap(p -> p.calendarId, p -> p.staffId));

    }

    public static Optional<Integer> calendarOfficeIdByStaffId(int staffOfficeId) {
        return Optional.ofNullable(STAFF_TO_CALENDAR_MAPPING.get(staffOfficeId));
    }


    public static final class CalendarStaffIdPair {
        public final int calendarId;
        public final int staffId;

        public static CalendarStaffIdPair of(int calendarId, int staffId) {
            return new CalendarStaffIdPair(calendarId, staffId);
        }
        private CalendarStaffIdPair(int calendarId, int staffId) {
            this.calendarId = calendarId;
            this.staffId = staffId;
        }
    }
}
