package ru.yandex.qe.mail.meetings.ws;

import ru.yandex.qe.mail.meetings.services.calendar.dto.EventDate;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Office;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Resource;

public class EventObject {
    private final Office office;
    private final Resource resource;
    private final EventDate event;

    public EventObject(Office office, Resource resource, EventDate event) {
        this.office = office;
        this.resource = resource;
        this.event = event;
    }

    public Office getOffice() {
        return office;
    }

    public Resource getResource() {
        return resource;
    }

    public EventDate getEvent() {
        return event;
    }

    @Override
    public String toString() {
        return "EventObject{" +
                "office=" + office +
                ", resource.email=" + resource.getResourceInfo().getEmail() +
                ", event=" + event +
                '}';
    }
}
