package ru.yandex.qe.mail.meetings.ws;

import java.util.HashMap;
import java.util.Map;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import freemarker.template.Configuration;
import org.apache.commons.lang3.CharEncoding;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;


import ru.yandex.qe.mail.meetings.api.resource.dto.CalendarAction;
import ru.yandex.qe.mail.meetings.config.NotificationConfiguration;
import ru.yandex.qe.mail.meetings.cron.AbstractMessageBuilder;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Event;
import ru.yandex.qe.mail.meetings.services.staff.StaffClient;
import ru.yandex.qe.mail.meetings.services.staff.dto.Person;

/**
 * @author Sergey Galyamichev
 */
@Component
public class SearchMessageBuilder extends AbstractMessageBuilder {
    private static final String TEMPLATE = "scan_started.ftl";
    private final String host;

    public SearchMessageBuilder(@Value("${meetings.host.url}") String host,
                                Configuration configuration,
                                StaffClient staffClient,
                                NotificationConfiguration notConfig) {
        super(configuration, staffClient, notConfig);
        this.host = host;
    }

    public void prepareMessage(MimeMessage mimeMessage, CalendarAction action, Event event) throws MessagingException {
        MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, CharEncoding.UTF_8);
        Person person = staffClient.getByLogin(getLogin(action.getEmail()));
        prepareMessageHeaders(message, action.getEmail(), null);
        message.setSubject(notConfig.getSearchStarted());
        message.setText(buildBody(person, action, event), true);
    }

    private String buildBody(Person person, CalendarAction action, Event event) throws MessagingException {
        try {
            Map<String, Object> valuesMap = new HashMap<>();
            valuesMap.put(NAME, person.getName().toString(person.getLanguage().getUi()));
            valuesMap.put("action", action);
            valuesMap.put("host", host);
            valuesMap.put("event", event);
            valuesMap.put("login", getLogin(action.getEmail()));
            return FreeMarkerTemplateUtils.processTemplateIntoString(configuration.getTemplate(TEMPLATE), valuesMap);
        } catch (Exception e) {
            throw new MessagingException("Unable to build body", e);
        }
    }

}
