package ru.yandex.qe.mail.meetings.ws.handlers;

public class HandlerResult<ErrorType> {
    private final ErrorType error;

    public HandlerResult(ErrorType error) {
        this.error = error;
    }

    public static <T> HandlerResult<T> ok() {
        return new HandlerResult<>(null);
    }

    public static <T> HandlerResult<T> error(T error) {
        return new HandlerResult<>(error);
    }


    public boolean isOk() {
        return error == null;
    }

    public ErrorType error() {
        return error;
    }

    public String metricReason() {
        return error.toString();
    }
}
