package ru.yandex.qe.mail.meetings.ws.mock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.qe.mail.meetings.services.calendar.CalendarUpdate;
import ru.yandex.qe.mail.meetings.services.calendar.dto.EventInfoShort;
import ru.yandex.qe.mail.meetings.services.calendar.dto.ReplyData;
import ru.yandex.qe.mail.meetings.services.calendar.dto.Response;
import ru.yandex.qe.mail.meetings.services.calendar.dto.WebEventCreateData;
import ru.yandex.qe.mail.meetings.services.calendar.dto.WebEventData;

/**
 * @author Sergey Galyamichev
 */
@Service("calendarUpdateMock")
public class CalendarUpdateMock implements CalendarUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(CalendarUpdateMock.class);

    private static Map<Integer, WebEventData> updated = new HashMap<>();
    private static Set<Integer> deleted = new HashSet<>();

    @Override
    public Response updateEvent(int eventId, int sequence, String instanceStartTs, Boolean applyToFuture, Boolean mailToAll, String uid, WebEventData event) {
        LOG.info("updateEvent");
        updated.put(eventId, event);
        return toOk(eventId, sequence);
    }

    @Override
    public Response deleteEvent(int eventId, int sequence, String instanceStartTs, Boolean applyToFuture, String uid) {
        LOG.info("deleteEvent");
        deleted.add(eventId);
        return toOk(eventId, sequence);
    }

    @Override
    public Response createEvent(WebEventCreateData event) {
        return new Response(Response.OK, 0, 0, null, null, null, null, null, null, null);
    }

    @Override
    public EventInfoShort handleReply(String uid, ReplyData replyData) {
        LOG.info("handleReply");
        return new EventInfoShort(replyData.getEventId());
    }

    public WebEventData getUpdated(int eventId) {
        return updated.get(eventId);
    }

    public boolean isDeleted(int eventId) {
        return deleted.contains(eventId);
    }

    private Response toOk(int eventId, int sequence) {
        return new Response(Response.OK, sequence + 1, eventId, null, null, null, null, null, null, null);
    }
}
