package ru.yandex.qe.mail.meetings.ws.sync;

import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.qe.mail.meetings.synchronizer.MeetingSynchronizer;
import ru.yandex.qe.mail.meetings.synchronizer.dto.IdWithType;
import ru.yandex.qe.mail.meetings.synchronizer.dto.SourceType;


@Service("syncHttpApi")
@Path("/sync")
@Produces("text/html; charset=UTF-8")
public class SyncHttpApi {
    private static final Logger LOG = LoggerFactory.getLogger(SyncHttpApi.class);

    @Nonnull
    private final MeetingSynchronizer meetingSynchronizer;
    @Nonnull
    private final SyncHtmlBuilder syncHtmlBuilder;

    @Inject
    public SyncHttpApi(@Nonnull MeetingSynchronizer meetingSynchronizer, @Nonnull SyncHtmlBuilder syncHtmlBuilder) {
        this.meetingSynchronizer = meetingSynchronizer;
        this.syncHtmlBuilder = syncHtmlBuilder;
    }

    @GET
    @Path("/list")
    public String list(@Nonnull @QueryParam("login") String login) {
        var eventToAssigned = meetingSynchronizer.getAllbyOwner(login);
        LOG.info("list for {} : {}", login, eventToAssigned);
        return syncHtmlBuilder.toPretty(eventToAssigned);
    }

    @GET
    @Path("/all")
    public String all() {
        var eventsToAssigned = meetingSynchronizer.getAllEventsWithLinkedGroups();
        return syncHtmlBuilder.toPretty(eventsToAssigned);
    }

    @GET
    @Path("/cancel")
    public String cancel(@Nonnull @QueryParam("eventId") Integer eventId) {
        meetingSynchronizer.unassign(eventId);
        return "OK";
    }

    @GET
    @Path("/unsubscribe")
    public String unsubscribe(@QueryParam("eventId") int eventId, @QueryParam("groupId") String groupId, @QueryParam("type") SourceType sourceType) {
        meetingSynchronizer.unassign(eventId, new IdWithType(groupId, sourceType));
        return "OK";
    }
}
